DROP TABLE `{pref}_user_group`;
DELETE FROM `{pref}_bbsessions`;

CREATE TABLE `{pref}_links` (
  `lid` int(11) NOT NULL auto_increment,
  `cid` int(11) NOT NULL default '0',
  `title` varchar(100) NOT NULL default '',
  `description` text NOT NULL,
  `url` varchar(100) NOT NULL default '',
  `img` varchar(100) NOT NULL default '',
  `date` datetime default NULL,
  `name` varchar(100) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `homepage` varchar(200) NOT NULL default '',
  `ip_sender` varchar(60) default NULL,
  `votes` int(11) NOT NULL default '0',
  `totalvotes` int(11) NOT NULL default '0',
  `totalcomments` int(11) NOT NULL default '0',
  `hits` int(11) NOT NULL default '0',
  `status` int(1) NOT NULL default '0',
  PRIMARY KEY  (`lid`),
  KEY `lid` (`lid`),
  KEY `cid` (`cid`),
  KEY `title` (`title`)
) TYPE=MyISAM;

CREATE TABLE `{pref}_links_categories` (
  `cid` int(11) NOT NULL auto_increment,
  `title` varchar(50) NOT NULL default '',
  `cdescription` text NOT NULL,
  `parentid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cid`),
  KEY `cid` (`cid`),
  KEY `title` (`title`)
) TYPE=MyISAM;

CREATE TABLE `{pref}_links_comments` (
  `tid` int(11) NOT NULL auto_increment,
  `lid` int(11) NOT NULL default '0',
  `date` datetime default NULL,
  `name` varchar(60) NOT NULL default '',
  `email` varchar(60) default NULL,
  `url` varchar(60) default NULL,
  `host_name` varchar(60) default NULL,
  `subject` varchar(255) NOT NULL default '',
  `comment` text NOT NULL,
  PRIMARY KEY  (`tid`),
  KEY `tid` (`tid`),
  KEY `lid` (`lid`)
) TYPE=MyISAM;

CREATE TABLE `{pref}_links_poolchec` (
  `lid` int(11) NOT NULL default '0',
  `time` varchar(14) NOT NULL default '',
  `host_addr` varchar(48) NOT NULL default '',
  KEY `time` (`time`)
) TYPE=MyISAM;

CREATE TABLE `{pref}_bbsessions_keys` (
  `key_id` varchar(32) DEFAULT '0' NOT NULL,
  `user_id` mediumint(8) DEFAULT '0' NOT NULL,
  `last_ip` varchar(8) DEFAULT '0' NOT NULL,
  `last_login` int(11) DEFAULT '0' NOT NULL,
  PRIMARY KEY (`key_id`, `user_id`),
  KEY `last_login` (`last_login`)
) TYPE=MyISAM;

INSERT INTO `{pref}_bbconfig` VALUES ('allow_autologin','1');
INSERT INTO `{pref}_bbconfig` VALUES ('max_autologin_time','0');

UPDATE `{pref}_users` SET user_active = 0 WHERE user_id = 1;
UPDATE `{pref}_bbconfig` SET config_value = '.0.18' WHERE config_name = 'version';

CREATE TABLE `{pref}_auto_links` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sitename` varchar(100) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `link` varchar(100) NOT NULL default '',
  `img` varchar(100) NOT NULL default '',
  `mail` varchar(100) NOT NULL default '',
  `hits` int(11) NOT NULL default '0',
  `outs` int(11) NOT NULL default '0',
  `added` datetime NOT NULL default '0000-00-00 00:00:00',
  UNIQUE KEY `id` (`id`)
) TYPE=MyISAM;

CREATE TABLE `{pref}_auto_links_ip` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ip` varchar(15) NOT NULL default '',
  `referer` varchar(255) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `referer_id` int(11) NOT NULL default '0',
  UNIQUE KEY `id` (`id`)
) TYPE=MyISAM;