<?php
/*/^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^/*/
/*/^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^/*/
/*/ Viet Gallery v1.0.101003									/*/
/*/ Copyright (C) 2003 Deathly Smile				            /*/
/*/ If you have any comments about Viet Gallery,				/*/
/*/			please send email to dsmile@softhome.net			/*/
/*/ You can use VGallery 1.0 freely for anypurposes				/*/
/*/ while all VietPHP's Copyright references					/*/
/*/ are kept on VGallery (small credit on Thumbnail,			/*/
/*/ the copyright at the footer and this copyright comment		/*/
/*/ in the sourcecode)											/*/
/*/^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^/*/
/*/ For more free PHP scripts,									/*/
/*/                visit Viet Gallery's Homepage at				/*/
/*/				http://www.vietphp.info							/*/
/*/^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^/*/
/*/^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^/*/
// ###################### Get time begin #######################
function startTracking(){
	global $starttime;
	$starttime = gettimeofday();
}

// ###################### Get time end and calculate time process #######################
function stopTracking(){
	global $starttime;
	$endtime = gettimeofday();
	return (round(($endtime['usec']-$starttime['usec'])/1000000 + abs($endtime['sec']-$starttime['sec']),3));
}
// End time
// ###################### Get template #######################
function gettemplate($template,$ex="htm") {
        global $templatefolder;
		if(!$templatefolder) $templatefolder = "templates";
        return str_replace("\"","\\\"",implode("",@file($templatefolder."/".$template.".".$ex)));
}

// ###################### Display template #######################
function dooutput($template) {
        echo $template;
}

function checkSubmitPixSize($filename) {
	global $maxfilesize, $maxwidth, $maxheight;
	$pixDimensions = getimagesize($filename);
	return (filesize($filename) && (filesize($filename)<=$maxfilesize*1024 || $maxfilesize==0) && ($pixDimensions[0]<=$maxwidth || $maxwidth==0) && ($pixDimensions[1]<= $maxheight || $maxheight==0))?true:false;
}

// auto parse URL
function parseURL($input) {
	$input = eregi_replace("[a-zA-Z0-9_]+@[a-zA-Z0-9\-]+\.[a-zA-Z0-9\-\.]+[[:alnum:]/]","<a href=\"mailto: \\0\">\\0</a>", $input);
	$input = eregi_replace(" (www.+\\..)"," http://\\1", $input);
	$input = eregi_replace("[[:alpha:]]+://[^<>[:space:]]+[[:alnum:]/]","<a href=\"\\0\" target=\"_blank\">\\0</a>", $input);
	return $input;
}

function formatInput($input) {
	return addslashes(htmlspecialchars(trim($input)));
}

function formatOutput($output,$wordwrap=0,$substr=0,$parseurl=0) {
	if($parseurl) $output = parseURL($output);
	if($wordwrap) $output = preg_replace("/([^\n\r ?&\.\/<>\"\\-]{".$wordwrap."})/i"," \\1\n",$output);
	if($substr && strlen($output)>=$substr) $output = substr($output,0,$substr-3)."...";
	return nl2br(stripslashes($output));
}

function doInclude($dirpath,$key) {
	global $lang;
	if($dir = @opendir("$dirpath")) {
		while (false !== ($filename = @readdir($dir))) {
			if(ereg($key,$filename)) include_once("$dirpath/$filename");
		}
	}
	else reportMSG($lang['gallery_request_error']['title'],$lang['gallery_request_error']['msg']);
}

function date_format($input_time, $format_type='') {
	global $language, $servertimezone, $localtimezone;
	$input_time = $input_time + 3600*$servertimezone - 3600*$localtimezone;
	if($language == "tiengviet") $default = date("H:i:s d/m/Y", $input_time); // Show date/time in Vietnamese style
	else $default = date("d/m/Y H:i:s", $input_time); // Show date/time in English style
	switch($format_type) {
		case '1' : $out = date("d/m/Y", $input_time); break; // Show date only
		case '2' : $out = date("H:i:s", $input_time); break; // Show time only
		default  : $out = $default; break;
	}
	return $out;
}

function checkPixType($pixfilename) {
	global $images_type_array;
	$type = substr(strrchr(strtolower($pixfilename),"."),1);
	return in_array($type,$images_type_array)?true:false;
}

function getImageType($imagepath) {
	global $lang;
	if($imageinfo = @getimagesize($imagepath)) {
		if($imageinfo[2] == 1) {
			$imagetype = "gif" ;
		}
		elseif($imageinfo[2] == 2) {
			$imagetype = "jpeg" ;
		}
		elseif($imageinfo[2] == 3) {
			$imagetype = "png" ;
		}
	}
	else reportMSG($lang['gallery_request_error']['title'],$lang['gallery_request_error']['msg']);
	return $imagetype;
}

function reportMSG($report_title, $report_message,$redirecturl='',$type='') {
	global $lang, $imagesdir;
	$msgbox_title = $report_title;
	$msgbox_messages = $report_message;
	if(!$redirecturl) $redirecturl = getenv("HTTP_REFERER");
	if(!$redirecturl) $redirecturl = "?";
	if($type) {
		$msg_header = "header_listblue.gif";
		$msg_icon = "msg_success.gif";
	}
	else {
		$msg_header = "header_listred.gif";
		$msg_icon = "msg_error.gif";
	}
	eval("dooutput(\"".gettemplate("gallery_msg")."\");");
	exit;
}

function setpage($sql,$per_page=1,$link="") {
	global $lang, $num_pages, $page, $pageindex, $prevpage, $nextpage, $firstpage, $lastpage, $imagesdir;
	// Set page #
	if(isset($_REQUEST['page'])) $page = (int)$_REQUEST['page'];
	if (!$page) $page = 1;
	$query = mysql_query($sql);

	// Set up specified page
	$page_start = ($per_page * $page) - $per_page;
	$num_rows = mysql_num_rows($query);
	if ($num_rows <= $per_page) $num_pages = 1;
	elseif($per_page)
		if (($num_rows % $per_page) == 0) $num_pages = ($num_rows / $per_page);
		else $num_pages = ($num_rows / $per_page) + 1;
	$num_pages = (int) $num_pages;
	if (($page > $num_pages) || ($page < 0)) {
		reportMSG($lang['gallery_request_error']['title'],$lang['gallery_request_error']['msg']);
	}
	// displaying...
	$sql = $sql . " LIMIT $page_start, $per_page";
	// display for page #
	for($i = 1; $i <= $num_pages; $i++)	{
		if($i != $page) eval ("\$pageindex .= \"".gettemplate("page_normal")."\";");
		else eval ("\$pageindex .= \"".gettemplate("page_current")."\";");
	}
	eval ("\$prevpage = \"".gettemplate("page_prevblur")."\";");
	eval ("\$firstpage = \"".gettemplate("page_firstblur")."\";");
	eval ("\$nextpage = \"".gettemplate("page_nextblur")."\";");
	eval ("\$lastpage = \"".gettemplate("page_lastblur")."\";");
	if($page > 1) {
		$prevpage = $page - 1;
		$firstpage = 1;
		eval ("\$prevpage = \"".gettemplate("page_prev")."\";");
		eval ("\$firstpage = \"".gettemplate("page_first")."\";");
	}
	if($page < $num_pages) {
		$nextpage = $page + 1;
		$lastpage = $num_pages;
		eval ("\$nextpage = \"".gettemplate("page_next")."\";");
		eval ("\$lastpage = \"".gettemplate("page_last")."\";");
	}
	return $sql;
}
?>