<?php

/**********************************************************************
   Program: Maian_Uploader v1.3 - Multiple Uploader Script.
   E-Mail: david@maiandream.co.uk
   This File: admin.php
   Module written by: David Ian Bennett (c)2003.
   Information: Administration to delete/view files with log file.
   Tested on: Linux Server running PHP 4.3.3
   Browser Testing: IE6
   ********************************************************************
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or (at
   your option) any later version. This program is distributed in the
   hope that it will be useful, but WITHOUT ANY WARRANTY; without even
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the GNU General Public License for more details.
   ********************************************************************/

////////////////////////
//Set Error Reporting///
////////////////////////

error_reporting (E_ALL ^ E_NOTICE);

/*Start Session*/

session_start();

/*Initialise include files.*/

@include("inc/config.php");
@include("lang/$language");

/////////////////////////////////////////////////////////////////////////
///If 'Logout' link is clicked, destroy session and display login page///
/////////////////////////////////////////////////////////////////////////

if ($_GET['action'] == "logout") { session_unset(); session_destroy(); login(); }

////////////////////////////////////////////////////////////
///If 'Delete' link is clicked, delete file and log entry///
////////////////////////////////////////////////////////////

if ($_GET['action'] == "delete")

{
    if (session_is_registered ("field_password"))
  {

   /*Open the log file for reading.*/

   $fp = fopen($server_path . "log/uploads.log","r+");

   $counter = 0;

   /*Get all the rows of data.*/

   while($linetemp = fgetcsv($fp,10000,""))

   {

     /*Load rows into a variable that aren`t to be removed.*/

     if ($counter != $row)

     {

       $linearr[$counter] = $linetemp;

     }

   $counter++;  
   unset($linetemp);

   }

   fclose($fp);

   /*Create new log file.*/

   $fp = fopen($server_path . "log/temp.log", "w+");

   $writestr = "";

   /*If something exists, write it to file, else write nothing.*/

   if (!empty($linearr))
   
   {

     foreach ($linearr as $newline)

     {

       $writestr .= implode("", $newline) . "\n";

     }
     
   }

   fwrite($fp,$writestr);
   fclose($fp);

   /*Now delete the original log file.*/

   @unlink($server_path . "log/uploads.log");
   
   /*Then rename new log file to same as old.*/

   @rename($server_path . "log/temp.log", $server_path . "log/uploads.log");
   
   /*Finally, delete actual file from uploads directory.*/

   @unlink($server_path . "uploads/" . $file);

   fileDeleted();

}
  }
////////////////////////////
//Encrypt current password//
////////////////////////////

if (isset($password)) { $secpass = md5($password); }

//////////////////////////////////////////////
///If 'Login' button is pressed, do actions///
//////////////////////////////////////////////

if ($_GET['action'] == "login")

{ 

  $field_password = md5($_POST['field_password']);

  /*If password entered is the same as the admin password, return true.*/

  if ($field_password == $secpass)
  
  {

    session_start(); 
    session_register('field_password');
    showFiles();

  }
  
  else
  
  /*Else display the login page again.*/
  
  {

    login();
    
  }

}

/*If session is active, display admin, otherwise display login page.*/

if (!session_is_registered('field_password')) { login(); } else { showFiles(); }

/////////////////////////////////////////////////
///Function that displays the admin login page///
/////////////////////////////////////////////////

function login() {

global $admin, $theme, $admin11, $login;

echo "<html dir=\"rtl\">\n";
echo "<head>\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ar-sa\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1256\">\n";
echo "<title>" . $admin . "</title>\n";
echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"templates/themes/" . $theme . "\">\n";
echo "</head>\n";

echo "<body topmargin=0 leftmargin=0 marginwidth=0 marginheight=0 onLoad=\"document.forms[0].field_password.focus();\">\n";

echo "<div align=\"center\"><center>\n";

echo "<form method=\"POST\" action=\"admin.php?action=login\">\n";
echo "<p>&nbsp;</p>\n";
echo "<table border=\"0\" width=\"45%\" style=\"border-width:2px; border-style: solid; border-color: #000000\">\n";
echo "<tr><td>&nbsp;</td></tr>\n";
echo "    <tr>\n";
echo "        <td align=\"right\" width=\"30%\"><strong>" . $admin11 . "</strong></td>\n";
echo "        <td width=\"70%\"><input type=\"password\" size=\"35\" name=\"field_password\"></td>\n";
echo "    </tr>\n";
echo "    <tr>\n";
echo "        <td>&nbsp;</td>\n";
echo "        <td>&nbsp;</td>\n";
echo "    </tr>\n";
echo "    <tr>\n";
echo "        <td align=\"center\" colspan=\"2\"><input type=\"submit\" value=\"" . $login . "\"></td>\n";
echo "    </tr>\n";
echo "<tr><td>&nbsp;</td></tr>\n";
echo "</table>\n";
echo "</form>\n";
echo "</center></div>\n";

showFooter();

}

/////////////////////
///End of function///
/////////////////////

/////////////////////////////////////////
///Function to show all uploaded files///
/////////////////////////////////////////

function showFiles() {

global $admin, $admin2, $admin3, $admin4, $admin5, $admin6, $admin7, $admin8, $logout, $theme, $url_path;

echo "<html dir=\"rtl\">\n";

echo "<head>\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ar-sa\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1256\">\n";
echo "<title>" . $admin . "</title>\n";
echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"templates/themes/" . $theme . "\">\n";
echo "</head>\n";

echo "<body topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>\n";

echo "<div align=\"center\"><center>\n";

echo "<table border=\"0\" cellpadding=\"5\" cellspacing=\"3\" width=\"100%\" style=\"border-width:2px; border-style: solid; border-color: #000000\">\n";
echo "    <tr>\n";
echo "        <td><b>" . $admin . "</b></td>\n";
echo "        <td align=\"right\"><b><a href=\"admin.php?action=logout\" style=\"text-decoration: none\">" . $logout . "</a></b></td>\n";
echo "    </tr>\n";
echo "</table>\n";
echo "</center></div><div align=\"center\"><center>\n";

echo "<table border=\"0\" width=\"100%\" style=\"border-width:2px; border-style: solid; border-color: #000000\">\n";
echo "<tr><td>&nbsp;</td></tr>\n";
echo "    <tr>\n";
echo "        <td width=\"15%\"><b><u>" . $admin2 . "</u></b></td>\n";
echo "        <td width=\"15%\"><b><u>" . $admin3 . "</u></b></td>\n";
echo "        <td width=\"25%\"><b><u>" . $admin4 . "</u></b></td>\n";
echo "        <td width=\"25%\"><b><u>" . $admin5 . "</u></b></td>\n";
echo "        <td width=\"15%\"><b><u>" . $admin6 . "</u></b></td>\n";
echo "        <td width=\"5%\"><b><u>" . $admin7 . "</u></b></td>\n";
echo "        <td width=\"5%\"><b><u>" . $admin8 . "</u></b></td>\n";
echo "    </tr>\n";
echo "<tr><td>&nbsp;</td></tr>\n";    

/*Initialise variables for paths.*/

$showfile = $url_path . "/uploads/";
$datafile = $server_path . "log/uploads.log";

/*Get information about log file.*/

$loadfile = @file($datafile);
$count = sizeof($loadfile);

/*Loop through all entries in log file.*/

for ($i=0; $i<$count; $i++)

{

  list ($date, $ip, $name, $email, $link, $size) = explode("|", $loadfile[$i]);

  $rows = $i;

  echo "    <tr>\n";
  echo "        <td>" . $date . "</td>\n";
  echo "        <td>" . $name . "</td>\n";
  echo "        <td><a href=\"mailto:" . $email . "\" style=\"text-decoration: none\">" . $email . "</a></td>\n";
  echo "        <td>" . $link . "</td>\n";
  echo "        <td>" . $size . "</td>\n";
  echo "        <td><a href=\"" . $url_path . "/uploads/" . $link . "\" target=\"_blank\"\ style=\"text-decoration: none\">" . $admin7 . "</a></td>\n";
  echo "        <td><a href=\"admin.php?action=delete&row=" . $rows. "&file=" . $link . "\" style=\"text-decoration: none\">" . $admin8 . "</a></td>\n";
  echo "    </tr>\n";

}

echo "<tr><td>&nbsp;</td></tr>\n";
echo "</table>\n";
echo "</center></div>\n";

showFooter();

}

/////////////////////
///End of function///
/////////////////////

/////////////////////////////////////////////////////
///Function to display message if files deleted ok///
/////////////////////////////////////////////////////

function fileDeleted() {

global $admin9, $admin10, $admin, $theme;

echo "<html dir=\"rtl\">\n";

echo "<head>\n";
echo "<meta http-equiv=\"Content-Language\" content=\"ar-sa\">\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1256\">\n";
echo "<title>" . $admin . "</title>\n";
echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"templates/themes/" . $theme . "\">\n";
echo "</head>\n";

echo "<body topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>\n";

echo "<meta http-equiv=\"refresh\" content=\"3;URL=admin.php\">\n";
echo "<p>&nbsp;</p>\n";
echo "<p align=\"center\"><b>" . $admin9 . "</b><br><br>" . $admin10 . "</p>\n";
exit;

}

/////////////////////
///End of function///
/////////////////////

//////////////////////////////////////
///Function to display admin footer///
//////////////////////////////////////

function showFooter() {

echo "<p align=\"center\"><font size=\"1\" face=\"Tahoma\">\n";
echo "Powered by <a class=\"footer\" href=\"http://www.m-dream.co.uk/php/scripts.php\" target=\"_new\" title=\"Maian_Uploader v1.3\">\n";
echo "Maian_Uploader v1.3</a></font></p>\n";
echo "<p align=\"center\"><font size=\"1\" face=\"Tahoma\">\n";
echo "  <a class=\"footer\" href=\"http://www.3ssom.com\" target=\"_new\" title=\"Maian_Uploader v1.3\">\n";
echo " </a></font></p>\n";
exit;

}

/////////////////////
///End of function///
/////////////////////

?>
