<?php

/**********************************************************************
   Program: Maian_Uploader v1.3 - Multiple Uploader Script.
   E-Mail: david@maiandream.co.uk
   This File: maianuploader.php
   Module written by: David Ian Bennett (c)2003.
   Information: Main Parser file and script action.
   Tested on: Linux Server running PHP 4.3.3
   Browser Testing: IE6
   ********************************************************************
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or (at
   your option) any later version. This program is distributed in the
   hope that it will be useful, but WITHOUT ANY WARRANTY; without even
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the GNU General Public License for more details.
   ********************************************************************/

////////////////////////
//Set Error Reporting///
////////////////////////

error_reporting (E_ALL ^ E_NOTICE);

/*Initialise include files.*/

@include("lib/template.inc");
@include("inc/config.php");
@include("lang/$language");

$t = new Template($server_path . "templates/");

@include("inc/header.php");

/////////////////////////////////////////////
//Function to show allowed file extensions///
/////////////////////////////////////////////

function showExtensions() {

global $which, $banext, $uploaderinfo;

  for ($counter=0; $counter<count($which); $counter++)

  {

    $banext .= "&nbsp;$which[$counter]\n";
    $uploaderinfo .= "&nbsp;$which[$counter]\n";

  }

}

/////////////////////
///End of function///
/////////////////////

///////////////////////////////////////////////////////
///If 'Upload File(s)' button is pressed, do actions///
///////////////////////////////////////////////////////

if ($_GET['action'] == "upload")

{

$field_name = trim($_POST['field_name']);
$field_email = trim($_POST['field_email']);
$field_subject = trim($_POST['field_subject']);
$field_comments = trim($_POST['field_comments']);
$field_userfile = trim($_FILES['userfile']);
$field_copy = $_POST['field_copy'];

/*Get users IP address.*/

$ipaddress = $REMOTE_ADDR;

/*Initialise integer for e-mail check*/

$loopcount = "0";

/*Now loop through all submitted files.*/

for($i=0; $i<count($_FILES[userfile][tmp_name]); $i++)

{

  $size = $_FILES[userfile][size][$i];
  $name = $_FILES[userfile][name][$i];
  $temp = $_FILES[userfile][tmp_name][$i];
  
  /*Increment count each time a file is submitted*/

  if ($name != "") { $loopcount = $loopcount+1; }

  $add = $i+1;
  $up = $up_field.$add;

  $uploaderinfo .= "<p align=\"center\"><b><u>" . $up . "</u></b></p>\n";

  $ext = strrchr($name, '.');

  #check file type set in array

  if ((!empty($name)) && ($ban) && !in_array($ext, $which))

  {

    $uploaderinfo .= "<div align=\"center\"><center>\n";
    $uploaderinfo .= "<table width=\"70%\" cellspacing=\"5\" cellpadding=\"3\">\n";

    $n = $f_name.$name;

    $uploaderinfo .= "<td align=\"left\"><p align=\"center\">" . $n . "<br>\n";

    /*Convert bytes into K-Bytes*/

    $div = "1000";
    $sum = $size / $div; //Do Division
    $sum = number_format($sum, 3); //3 decimal places

    $what = "KB";
    $s = $f_size.$sum.$what;

    $uploaderinfo .= "" . $s . "<br><br>\n";
    $uploaderinfo .= "<b>" . $f_filetypes . "</b><br><br>";

    showExtensions();

    $uploaderinfo .= "</p>";
    $uploaderinfo .= "</td></tr>\n";
    $uploaderinfo .= "</table></center></div>\n";
    $uploaderinfo .= "<hr width=\"70%\" size=\"1\"><br>\n";

    }

    #see if file exists already

    else if (is_file($server_path . "uploads/" . $name))

    {

      #If enabled, add prefix to file name

      if ($changefiles)

      {

        $prefix = time();

        $newfilename = $prefix . "_" . $_FILES[userfile][name][$i];

        $location = $server_path . "uploads/" . $newfilename;
        @move_uploaded_file($temp, $location);

        #chmod file to 644 to make it removable via FTP

        chmod($location, 0644);

        $uploaderinfo .= "<div align=\"center\"><center>\n";
        $uploaderinfo .= "<table width=\"70%\" cellspacing=\"5\" cellpadding=\"3\">\n";

        $n = $f_name.$newfilename;

        $uploaderinfo .= "<td align=\"left\"><p align=\"center\">" . $n . "<br>\n";

        /*Convert bytes into K-Bytes*/

        $div = "1000";
        $sum = $size / $div; //Do Division
        $sum = number_format($sum, 3); //3 decimal places

        $what = "KB";
        $s = $f_size.$sum.$what;

        $loopfiles .= "<b>" . $f_files . "</b><a href=\"" . $url_path . "/uploads/" . $newfilename . "\">" . $newfilename . "</a><br>\n";
        $visfiles .= "<b>" . $f_files . "</b>" . $newfilename . "<br>\n";

        $uploaderinfo .= "" . $s . "<br><br>\n";
        $uploaderinfo .= "<b>" . $f_success . "</b><br><br>";

        #If link is to be shown, show link

        if ($see_url)

        {

      	  $uploaderinfo .= $f_link . "<br><a href=\"" . $url_path . "/uploads/" . $newfilename . "\" target=\"_blank\">" . $url_path . "/uploads/" . $newfilename . "</a><br><br>\n";

        }

        #If entries are to be logged, log them

        if ($log)

        {

          $date = date("d-m-y H:i:s");
          $log_entries = $date. "|" .$ipaddress. "|" .$field_name. "|" .$field_email. "|" .$newfilename. "|" .$sum.$what. "|\n";
          $fp = fopen($server_path . "log/uploads.log", "ab") or die("ERROR!! Cannot create 'uploads.log' file. Check to make sure the 'log' directory is chmoded to '777'. If it is, see the 'ReadMe' file for a possible solution");

          if ($fp != false)

          {

            fwrite($fp, $log_entries);
            fclose($fp);

          }

        }

        $uploaderinfo .= "</p></td></tr>\n";
        $uploaderinfo .= "</table></center></div>\n";
        $uploaderinfo .= "<hr width=\"70%\" size=\"1\"><br>\n";

      }

      else

      {
	
        $uploaderinfo .= "<div align=\"center\"><center>\n";
        $uploaderinfo .= "<table width=\"70%\" cellspacing=\"5\" cellpadding=\"3\">\n";

        $n = $f_name.$name;

        $uploaderinfo .= "<td align=\"left\"><p align=\"center\">" . $n . "<br>\n";

        /*Convert bytes into K-Bytes*/

        $div = "1000";
        $sum = $size / $div; //Do Division
        $sum = number_format($sum, 3); //3 decimal places

        $what = "KB";
        $s = $f_size.$sum.$what;

        $uploaderinfo .= "" . $s . "<br><br>\n";
        $uploaderinfo .= "<b>" . $f_exists . "</b><br><br></p></td></tr>\n";
        $uploaderinfo .= "</table></center></div>\n";
        $uploaderinfo .= "<hr width=\"70%\" size=\"1\"><br>\n";

      }

    }

    #check that file is within the size restrictions

    else if($size > 0 && $size < $max_file)

    {

    #If ok, upload files

    $location = $server_path . "uploads/" . $name;
    @move_uploaded_file($temp, $location);
    
    #chmod file to 644 to make it removable via FTP

    chmod($location, 0644);

    $uploaderinfo .= "<div align=\"center\"><center>\n";
    $uploaderinfo .= "<table width=\"70%\" cellspacing=\"5\" cellpadding=\"3\">\n";

    $n = $f_name.$name;

    $uploaderinfo .= "<td align=\"left\"><p align=\"center\">" . $n . "<br>\n";

    /*Convert bytes into K-Bytes*/

    $div = "1000";
    $sum = $size / $div; //Do Division
    $sum = number_format($sum, 3); //3 decimal places

    $what = "KB";
    $s = $f_size.$sum.$what;
    $loopfiles .= "<b>" . $f_files . "</b><a href=\"" . $url_path . "/uploads/" . $name . "\">" . $name . "</a><br>\n";
    $visfiles .= "<b>" . $f_files . "</b>" . $name . "<br>\n";

    $uploaderinfo .= "" . $s . "<br><br>\n";
    $uploaderinfo .= "<b>" . $f_success . "</b><br><br>";
    
      #If link is to be shown, show link

      if ($see_url)
      
      {
      	
      	$uploaderinfo .= $f_link . "<br><a href=\"" . $url_path . "/uploads/" . $name . "\" target=\"_blank\">" . $url_path . "/uploads/" . $name . "</a><br><br>\n";
      	
      }
      
      #If entries are to be logged, log them

      if ($log)
      
      {

        $date = date("d-m-y H:i:s");
        $log_entries = $date. "|" .$ipaddress. "|" .$field_name. "|" .$field_email. "|" .$name. "|" .$sum.$what. "|\n";
        $fp = fopen($server_path . "log/uploads.log", "ab") or die("ERROR!! Cannot create 'uploads.log' file. Check to make sure the 'log' directory is chmoded to '777'. If it is, see the 'ReadMe' file for a possible solution");

        if ($fp != false)

        {

          fwrite($fp, $log_entries);
          fclose($fp);

        }

      }

    $uploaderinfo .= "</p></td></tr>\n";
    $uploaderinfo .= "</table></center></div>\n";
    $uploaderinfo .= "<hr width=\"70%\" size=\"1\"><br>\n";

    }

    #Check that file is within size restrictions 2

    else if ($size > 0 && $size > $max_file)

    {

    $uploaderinfo .= "<div align=\"center\"><center>\n";
    $uploaderinfo .= "<table width=\"70%\" cellspacing=\"5\" cellpadding=\"3\">\n";

    $n = $f_name.$name;

    $uploaderinfo .= "<td align=\"left\"><p align=\"center\">" . $n . "<br>\n";

    /*Convert bytes into K-Bytes*/    

    $div = "1000";
    $sum = $size / $div; //Do Division
    $sum = number_format($sum, 3); //3 decimal places

    $what = "KB";
    $s = $f_size.$sum.$what;

    $uploaderinfo .= "" . $s . "<br><br>\n";
    $uploaderinfo .= "<b>" . $f_exceed . "</b><br><br>" . $m_max . "<br><br></p></td></tr>\n";
    $uploaderinfo .= "</table></center></div>\n";
    $uploaderinfo .= "<hr width=\"70%\" size=\"1\"><br>\n";

    }

    #else display nothing if nothing selected

    else

    {

    $uploaderinfo .= "<div align=\"center\"><center>\n";
    $uploaderinfo .= "<table width=\"70%\" cellspacing=\"5\" cellpadding=\"3\">\n";
    $uploaderinfo .= "<td align=\"left\"><p align=\"center\">" . $f_noterror . "</p>\n";
    $uploaderinfo .= "</td></tr></table></center></div>\n";
    $uploaderinfo .= "<br><hr width=\"70%\" size=\"1\"><br><br>\n";

  }

}

/*If comments are used, show them in e-mail.*/

if ($comments)

{

  $subcom = "<b>" . $f_comments . "</b><br><br>" . $field_comments . "<br><br>\n";
  
}

else

/*Show nothing.*/

{

  $subcom = "<br><br>\n";
  
}

/*Send e-mail to webmaster if at least 1 file was submitted*/

if ($loopcount>0)

{

    $headers = "Content-type: text/html; charset=windows-1256\r\n";
    $headers .= "Content-Language: content=ar-sa\r\n";
    $headers .= ": $field_name<$field_email>\r\n";
    $headers .= "X-Sender: $field_email\n";
    $headers .= "X-Mailer: PHP\n";
    $headers .= "X-Priority: 3\n";
    $headers .= "Return-Path: $field_email\n";
    $headers .= "Reply-To: $field_name<$field_email>\n";
    $message = "<font face=\"Tahoma\" size=\"2\">\n";
    $message .= $message1 . $owner . "<br><br>\n";
    $message .= $field_name . " " . $message2 . "<br><br>\n";
    $message .= "<b>" . $m_field_email . "</b><a href=\"mailto:" . $field_email . "\">" . $field_email . "</a><br>\n";
    $message .= "<b>" . $m_field_subject . "</b>" . $field_subject . "<br>\n";
    $message .= $loopfiles;
    $message .= $subcom;
    
    if ($log)
    
    {

      $message .= $message3 . "<br><a href=\"" . $url_path . "/admin.php\">" . $url_path . "/admin.php</a></font><br><br><br>\n";

    }
    
    else
    
    {

      $message .= $message3 . "<br><a href=\"" . $url_path . "/admin2.php\">" . $url_path . "/admin2.php</a></font><br><br><br>\n";

    }

    $message .= "<hr size=\"1\"><font size=\"1\" face=\"verdana\">Free uploader script provided by <a href=\"http://www.m-dream.co.uk/php/scripts.php\">M-Dream<a></font><hr size=\"1\">\n";

    $message = stripslashes($message);
    $email_subject = stripslashes($email_subject);
    $message = ereg_replace("javascript", "", $message);

    mail($your_email, $site_name . " " . $email_subject, $message, $headers);
    
    /*If visitor has chosen to receive confirmation, send message.*/

    if ($field_copy == "Yes")

    {
    	
    $headers = "Content-type: text/html; charset=windows-1256\r\n";
    $headers .= "Content-Language: content=ar-sa\r\n";
    $headers .= ": $site_name<$your_email>\r\n";
    $headers .= "X-Sender: $your_email\n";
    $headers .= "X-Mailer: PHP\n";
    $headers .= "X-Priority: 3\n";
    $headers .= "Return-Path: $your_email\n";
    $headers .= "Reply-To: $site_name<$your_email>\n";
    $message = "<font face=\"verdana\" size=\"2\">\n";
    $message .= $auto1 . $field_name . "<br><br>\n";
    $message .= $auto2 . "<br><br>\n";
    $message .= "<b>" . $m_field_email . "</b><a href=\"mailto:" . $field_email . "\">" . $field_email . "</a><br>\n";
    $message .= "<b>" . $m_field_subject . "</b>" . $field_subject . "<br>\n";
    
    /*If link is displayed to visitor after uploading, show link in e-mail too.*/

    if ($see_url)
    
    {

      $message .= $loopfiles;
      
    }
    
    else

    /*Show no link.*/
    
    {
    	
      $message .= $visfiles;
      
    }
    
    $message .= $subcom;
    $message .= $auto3 . "<br><br>" . $auto4 . "<br><br>\n";
    $message .= $owner . "<br>" . $site_name . "<br><a href=\"" . $site_url . "\">" . $site_url . "</a></font><br><br><br>\n";
    $message .= "<hr size=\"1\"><font size=\"1\" face=\"verdana\">Free uploader script provided by <a href=\"http://www.m-dream.co.uk/php/scripts.php\">M-Dream<a></font><hr size=\"1\">\n";

    $message = stripslashes($message);
    $user_subject = stripslashes($user_subject);
    $message = ereg_replace("javascript", "", $message);

    mail($field_email, $user_subject, $message, $headers);

    }
    
}

/*Parse the thanks.html page.*/

$t ->set_file(array("THANKS" => "thanks.html"));
$t ->set_var(array(
                   "THANK_YOU" => $thanks,
                   "UPLOAD_DETAILS" => $uploaderinfo
                   ));

                   $t ->parse("output", "THANKS");

                   $t ->p("output");

@include("inc/footer.php");

} //end if

$banext = "<p align=\"center\">" . $m_max . "</p>";

/*If some file types aren`t allowed, show which ones.*/

if ($ban)

{

  $banext .= "<p align=\"center\">" . $m_extensions . "";

  showExtensions();

  $banext .= "]</p>";

}

/*Show specified upload fields.*/

$num = 0;

while ($num < $upload_num)

{

  $up .= "    <tr>\n";
  $up .= "        <td width=\"35%\"><p align=\"right\"><b>" . $m_field_upload . "</b></p>\n";
  $up .= "        </td>\n";
  $up .= "        <td width=\"65%\"><p align=\"left\"><input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"" . $max_size . "\">\n";
  $up .= "        <input type=\"file\" size=\"30\" name=\"userfile[]\"></p>\n";
  $up .= "        </td>\n";
  $up .= "    </tr>\n";
  $num++;

}

/*If comments are used, show text area for comments.*/

if ($comments)

{

  $com = "   <tr>\n";
  $com .= "        <td width=\"35%\"><p align=\"right\"><b>" . $m_field_comments . "</b>\n";
  $com .= "        </p>\n";
  $com .= "        </td>\n";
  $com .= "        <td width=\"65%\"><p align=\"left\"><textarea name=\"field_comments\" rows=\"8\" cols=\"40\"></textarea></p>\n";
  $com .= "        </td>\n";
  $com .= "    </tr>\n";

}

/*Parse the index.html file.*/

$t ->set_file(array("INDEX" => "index.html"));
$t ->set_var(array(
                   "EXTENSIONS" => $banext,
                   "NAME" => $m_field_name,
                   "EMAIL" => $m_field_email,
                   "SUBJECT" => $m_field_subject,
                   "UPLOAD_FIELDS" => $up,
                   "COMMENTS_FIELD" => $com,
                   "RECEIVE_COPY" => $m_field_check,
                   "UPLOAD_FILES" => $m_submit
                   ));

                   $t ->parse("output", "INDEX");

                   $t ->p("output");

@include("inc/footer.php");

///////////////////////////////////////////
///Function to show javascript alert box///
///////////////////////////////////////////

function jsMessage($msg) {

echo "<script language=\"javascript\">\n";
echo "<!-- \n";
echo " alert (\"$msg\")\n";
echo " // --> \n";
echo " </script>\n";

}

/////////////////////
///End of function///
/////////////////////

?>
